UNIT FileSrch;

INTERFACE

USES Dos;

TYPE
  SearchProc = PROCEDURE(VAR S: SearchRec; P:PathStr);

FUNCTION Searcher(Mask: PathStr; Attr: Byte; SP: SearchProc): Byte;

FUNCTION AllSearcher(Mask: PathStr; Attr: Byte; SP: SearchProc): Byte;

IMPLEMENTATION

FUNCTION Searcher(Mask: PathStr; Attr: Byte; SP: SearchProc): Byte;
VAR
  SR: SearchRec;
  Ds: DirStr;
  Ns: NameStr;
  Es: ExtStr;
BEGIN
  FindFirst(Mask, Attr, SR);
  IF DosError <> 0 THEN
    Searcher := DosError
  ELSE BEGIN
    FSplit(Mask, Ds, Ns, Es);
    WHILE DosError = 0 DO BEGIN
      SP(SR, Ds);
      FindNext(SR);
    END;
    IF DosError = 18 THEN
      Searcher := 0
    ELSE
      Searcher := DosError;
  END;
END;  { Searcher }

VAR
  GlobalSearchDirMask: String[12];
  GlobalSearchDirAttr: Byte;
  GlobalSearchDirProc: SearchProc;

{$F+}
PROCEDURE SearchDir(VAR S: SearchRec; P: PathStr); {FAR;}
BEGIN
  IF (S.Name[1] <> '.') AND (S.Attr AND Directory > 0) THEN BEGIN
    P := P + S.Name;
    IF Searcher(P + '\' + GlobalSearchDirMask, GlobalSearchDirAttr,
                          GlobalSearchDirProc) = 0 THEN;
    IF Searcher(P + '\*.*', Directory OR Archive, SearchDir) = 0 THEN;
  END;
END;  { SearchDir }
{$F-}

FUNCTION AllSearcher(Mask: PathStr; Attr: Byte; SP: SearchProc): Byte;
VAR
  SR: SearchRec;
  Ds: DirStr;
  Ns: NameStr;
  Es: ExtStr;
  Er: Byte;
BEGIN
  FSplit(Mask, Ds, Ns, Es);
  GlobalSearchDirMask := Ns+Es;
  GlobalSearchDirAttr := Attr;
  GlobalSearchDirProc := SP;
  Er := Searcher(Mask, Attr, SP);
  IF (Er = 0) OR (Er = 18) THEN
    AllSearcher := Searcher(Ds+'*.*', Directory OR Archive, SearchDir)
  ELSE
    AllSearcher := Er;
END;  { AllSearcher }

END.